/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;

public class CrossPortalViewRendering {
    public static final Minecraft client = Minecraft.m_91087_();

    public static boolean renderCrossPortalView() {
        Vec3 renderingCameraPos;
        if (!IPGlobal.enableCrossPortalView) {
            return false;
        }
        Entity cameraEntity = CrossPortalViewRendering.client.f_91075_;
        Camera camera1 = new Camera();
        float cameraY = ((IECamera)RenderStates.originalCamera).getCameraY();
        float lastCameraY = ((IECamera)RenderStates.originalCamera).getLastCameraY();
        ((IECamera)camera1).setCameraY(cameraY, lastCameraY);
        Camera camera = camera1;
        camera.m_90575_((BlockGetter)CrossPortalViewRendering.client.f_91073_, cameraEntity, CrossPortalViewRendering.isThirdPerson(), CrossPortalViewRendering.isFrontView(), RenderStates.getPartialTick());
        Vec3 realCameraPos = camera.m_90583_();
        Vec3 isometricAdjustedOriginalCameraPos = TransformationManager.getIsometricAdjustedCameraPos(camera);
        Vec3 physicalPlayerHeadPos = ClientTeleportationManager.getPlayerEyePos(RenderStates.getPartialTick());
        Pair portalHit = PortalCommand.raytracePortals((Level)CrossPortalViewRendering.client.f_91073_, physicalPlayerHeadPos, isometricAdjustedOriginalCameraPos, true).orElse(null);
        if (portalHit == null) {
            return false;
        }
        Portal portal = (Portal)portalHit.getFirst();
        Vec3 hitPos = (Vec3)portalHit.getSecond();
        if (!portal.canTeleportEntity(cameraEntity)) {
            return false;
        }
        if (CrossPortalViewRendering.isThirdPerson()) {
            double distance = CrossPortalViewRendering.getThirdPersonMaxDistance();
            Vec3 thirdPersonPos = realCameraPos.m_82546_(physicalPlayerHeadPos).m_82541_().m_82490_(distance).m_82549_(physicalPlayerHeadPos);
            renderingCameraPos = CrossPortalViewRendering.getThirdPersonCameraPos(thirdPersonPos, portal, hitPos);
        } else {
            renderingCameraPos = portal.transformPoint(realCameraPos);
        }
        ((IECamera)RenderStates.originalCamera).portal_setPos(renderingCameraPos);
        WorldRenderInfo worldRenderInfo = new WorldRenderInfo.Builder().setWorld(ClientWorldLoader.getWorld(portal.dimensionTo)).setCameraPos(renderingCameraPos).setCameraTransformation(portal.getAdditionalCameraTransformation()).setOverwriteCameraTransformation(true).setDescription(null).setRenderDistance(CrossPortalViewRendering.client.f_91066_.m_193772_()).setDoRenderHand(false).setEnableViewBobbing(false).build();
        IPCGlobal.renderer.invokeWorldRendering(worldRenderInfo);
        return true;
    }

    private static boolean isFrontView() {
        return CrossPortalViewRendering.client.f_91066_.m_92176_().m_90613_();
    }

    private static boolean isThirdPerson() {
        return !CrossPortalViewRendering.client.f_91066_.m_92176_().m_90612_();
    }

    private static Vec3 getThirdPersonCameraPos(Vec3 endPos, Portal portal, Vec3 startPos) {
        Vec3 rtStart = portal.transformPoint(startPos);
        Vec3 rtEnd = portal.transformPoint(endPos);
        BlockHitResult blockHitResult = portal.getDestinationWorld().m_45547_(new ClipContext(rtStart, rtEnd, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CrossPortalViewRendering.client.f_91075_));
        if (blockHitResult == null) {
            return rtStart.m_82549_(rtEnd.m_82546_(rtStart).m_82541_().m_82490_(CrossPortalViewRendering.getThirdPersonMaxDistance()));
        }
        return blockHitResult.m_82450_();
    }

    private static double getThirdPersonMaxDistance() {
        return 4.0 * (double)PehkuiInterface.invoker.computeThirdPersonScale((Entity)CrossPortalViewRendering.client.f_91074_, client.m_91296_());
    }
}

